//
//  MPStatistics.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/2/14.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//NOTE:This enums are also ids of events
/**
 Open image in app named
*/
typedef NS_ENUM(NSUInteger, MPStatisticsOpenIn) {
    ///Intensify
    MPStatisticsOpenInIntensify = 1,
    ///Snapheal
	MPStatisticsOpenInSnapheal,
    ///FX PhotoStudio
	MPStatisticsOpenInFXPhotoStudio,
    ///iPhoto
	MPStatisticsOpenInIPhoto,
    ///Aperture
	MPStatisticsOpenInAperture,
    ///Photoshop
	MPStatisticsOpenInPhotoshop,
    ///Photoshop Elements
	MPStatisticsOpenInPhotoshopElements,
    ///Lightroom
	MPStatisticsOpenInLightroom,
    ///Focus
    MPStatisticsOpenInFocus,
    ///Tonality
    MPStatisticsOpenInTonality = 43,
};

/**
 Share image to
 */
typedef NS_ENUM(NSUInteger, MPStatisticsShareTo) {
    ///Mail
	MPStatisticsShareToMail = 10,
    ///Facebook
	MPStatisticsShareToFaceBook,
    ///Twitter
	MPStatisticsShareToTwitter,
    ///Flickr
	MPStatisticsShareToFlickr,
    ///Messages
	MPStatisticsShareToMessages,
    ///Airdrop
	MPStatisticsShareToAirDrop,
    ///SmugMug
    MPStatisticsShareToSmugMug,
};

/**
 Used to send Statistics about using app
*/
@interface MPStatistics : NSObject

/**
 Start sending statistics
 
 This method start heandling sessions and setups timer for sending events to the server
 */
+ (void)start;

/**
 Start sending statistics
 
 This method start heandling sessions and setups timer for sending events to the server
 
 @param buildType If is set sends an open app event with the defined build type
 */
+ (void)startWithBuildType:(NSString *)buildType;

/**
 Send event Open in Plugin Mode
*/
+ (void)openedInPluginMode;

/**
 Send event Open in some app
 
 @param openInId The id of App to open in
 */
+ (void)openIn:(MPStatisticsOpenIn)openInId;

/**
 Send event Share to some service
 
 @param shareToId The id of service to share to
 */
+ (void)shareTo:(MPStatisticsShareTo)shareToId;

/**
 Send event Share to standard sharing service
 
 @param sharingService Sharing service to use
 */
+ (void)shareToSharingService:(NSSharingService *)sharingService;

/**
 Send event Image Did Load
 */
+ (void)imageDidLoad;

/**
 Send event Image was saved
 */
+ (void)imageWasSaved;

/**
 Send event Exported to Image
 */
+ (void)exportedToImage;

/**
 Send event Sharing window did open
 */
+ (void)sharingWindowDidOpen;

/**
 Send event Macphun Printlab(Milkbooks)
 */
+ (void)printlabWindowDidOpen;

/**
 Send event Save to document
 */
+ (void)savedToDocument;

/**
 Apply preset event
 
 @param presetName The name of the preset
 @param categoryName Preset category name
 */
+ (void)presetAppliedWithName:(NSString *)presetName categoryName:(NSString *)categoryName;

/**
 Send event when opening welcome window
 */
+ (void)welcomeScreenOpened;

/**
 Send event when subscribing email in welcome window
 */
+ (void)emailSubscribed;

/**
 Send event with specific id
 
 @param eventId id of event to send
 */
+ (void)sendEventWithId:(NSInteger)eventId;

/**
 Force send of all events
 
 @param completionHandler Async completion Handler
 */
+ (void)sendEventsWithCompletionHandler:(void(^)(BOOL success))completionHandler;

/**
 Force sync sending of all events
 */
+ (BOOL)sendEvents;

@end
